@echo off
setlocal enabledelayedexpansion
chcp 65001 >nul

REM Verifica se esta sendo executado como administrador
net session >nul 2>&1
if %ERRORLEVEL% NEQ 0 (
    color 4F
    cls
    echo ========================================
    echo   Instalador RustDesk - Go Smart
    echo ========================================
    echo.
    echo [ERRO] Este script precisa ser executado como Administrador!
    echo.
    echo Para executar como administrador:
    echo 1. Clique com o botao direito no arquivo
    echo 2. Selecione "Executar como administrador"
    echo.
    echo Ou execute via Prompt de Comando/PowerShell como administrador.
    echo.
    pause
    exit /b 1
)

color 2F
cls
echo ========================================
echo   Instalador RustDesk - Go Smart
echo ========================================
echo.
echo Baixando script de instalacao...
echo.

powershell.exe -NoProfile -ExecutionPolicy Bypass -Command "$h=@{Authorization='Basic '+[Convert]::ToBase64String([Text.Encoding]::ASCII.GetBytes('admin:DdUeHcUetFAEIEJj'))}; Invoke-WebRequest -Uri 'http://rustdesk.gosmart.com.br/WindowsAgentAIOInstall.ps1' -Headers $h -OutFile '%TEMP%\install.ps1'; & '%TEMP%\install.ps1'"

if %ERRORLEVEL% NEQ 0 (
    echo.
    echo ERRO: Falha na instalacao.
    pause
    exit /b %ERRORLEVEL%
)

echo.
echo [OK] Instalacao concluida com sucesso!
echo.
echo Aguardando inicializacao do servico RustDesk...
echo.

REM Para o servico RustDesk se estiver rodando
net stop RustDesk >nul 2>&1

REM Inicia o servico
net start RustDesk >nul 2>&1

REM Aguarda 30 segundos com progresso
set /a SEGUNDOS=30
echo Aguardando %SEGUNDOS% segundos para o servico inicializar completamente...
echo.

:AGUARDA_LOOP
set /a PERCENTUAL=100-!SEGUNDOS!*100/30
set /a BARRAS=!PERCENTUAL!/5
set "BARRA_PROGRESSO="
for /l %%i in (1,1,!BARRAS!) do set "BARRA_PROGRESSO=!BARRA_PROGRESSO!█"
set /a RESTANTE=20-!BARRAS!
for /l %%i in (1,1,!RESTANTE!) do set "BARRA_PROGRESSO=!BARRA_PROGRESSO!░"

REM Constroi a mensagem completa
set "MSG_PROGRESSO=[!PERCENTUAL!%%] !BARRA_PROGRESSO! !SEGUNDOS! segundos restantes   "

REM Usa PowerShell para sobrescrever a mesma linha
powershell.exe -NoProfile -Command "[Console]::SetCursorPosition(0, [Console]::CursorTop); Write-Host '!MSG_PROGRESSO!' -NoNewline" 2>nul
if errorlevel 1 (
    REM Fallback: usa set /p se PowerShell falhar
    set /p="!MSG_PROGRESSO!"<nul
)
timeout /t 1 /nobreak >nul 2>&1

set /a SEGUNDOS-=1
if !SEGUNDOS! GTR 0 goto AGUARDA_LOOP

REM Linha final - sobrescreve na mesma linha
set "MSG_FINAL=[100%%] ████████████████████ Configuracao iniciando..."
powershell.exe -NoProfile -Command "[Console]::SetCursorPosition(0, [Console]::CursorTop); Write-Host '!MSG_FINAL!' -NoNewline" 2>nul
if errorlevel 1 (
    set /p="!MSG_FINAL!"<nul
)
echo.
echo.

echo Configurando senha permanente...
echo.

REM Configura a senha permanente
"C:\Program Files\RustDesk\rustdesk.exe" --password "GoTech2017" >nul 2>&1

if %ERRORLEVEL% EQU 0 (
    echo [OK] Senha permanente configurada com sucesso!
    echo.
) else (
    echo [AVISO] Nao foi possivel configurar a senha permanente automaticamente.
    echo A senha pode ser configurada manualmente nas configuracoes do RustDesk.
    echo.
)

echo Configurando PIN de desbloqueio das configuracoes de seguranca...
echo.

REM Configura o PIN de desbloqueio
"C:\Program Files\RustDesk\rustdesk.exe" --set-unlock-pin 2017 >nul 2>&1

if %ERRORLEVEL% EQU 0 (
    echo [OK] PIN de desbloqueio configurado com sucesso!
    echo.
) else (
    echo [AVISO] Nao foi possivel configurar o PIN de desbloqueio automaticamente.
    echo O PIN pode ser configurado manualmente nas configuracoes do RustDesk.
    echo.
)

echo Configurando arquivo RustDesk2.toml...
echo.

REM Configura o arquivo RustDesk2.toml
set "RUSTDESK_CONFIG=%APPDATA%\RustDesk\config"
set "RUSTDESK2_TOML=%RUSTDESK_CONFIG%\RustDesk2.toml"

REM Cria a pasta se nao existir
if not exist "%RUSTDESK_CONFIG%" (
    mkdir "%RUSTDESK_CONFIG%" >nul 2>&1
)

REM Usa PowerShell inline para configurar o arquivo TOML
powershell.exe -NoProfile -ExecutionPolicy Bypass -Command "& {$file='%RUSTDESK2_TOML%';$configs=@{'allow-remote-config-modification'='Y';'enable-audio'='N';'enable-camera'='N'};if(Test-Path $file){$lines=Get-Content $file;$newLines=@();$updated=@{};foreach($line in $lines){$matched=$false;foreach($key in $configs.Keys){if($line -match \"^\\s*$([regex]::Escape($key))\\s*=\"){$newLines+=\"$key = '$($configs[$key])'\";$updated[$key]=$true;$matched=$true;break}}if(-not $matched){$newLines+=$line}};foreach($key in $configs.Keys){if(-not $updated[$key]){$newLines+=\"$key = '$($configs[$key])'\";Write-Host \"[OK] Configuracao '$key' adicionada\" -ForegroundColor Green}else{Write-Host \"[OK] Configuracao '$key' atualizada\" -ForegroundColor Green}};Set-Content $file $newLines -Encoding UTF8}else{$newContent=@();foreach($key in $configs.Keys){$newContent+=\"$key = '$($configs[$key])'\";Write-Host \"[OK] Configuracao '$key' adicionada\" -ForegroundColor Green};Set-Content $file $newContent -Encoding UTF8}}"

if %ERRORLEVEL% EQU 0 (
    echo.
    echo [OK] Configuracoes do RustDesk2.toml aplicadas com sucesso!
    echo.
) else (
    echo.
    echo [AVISO] Nao foi possivel configurar o arquivo RustDesk2.toml automaticamente.
    echo As configuracoes podem ser adicionadas manualmente.
    echo.
)

REM Tenta iniciar o servico novamente
net start RustDesk >nul 2>&1

echo ========================================
echo   Instalacao Finalizada
echo ========================================
echo.
pause
